%% Rastrigin Function 
% Its a multi-modal version of DeJong/Spherical function, characterized by
% deep local minima arranged as sinusoidal bumps. An optimization algorithm
% can easily become trapped in local minimum on its way to the global
% minimizer.
%
% * It is multi-modal function
% * Minima : [0, 0, ..., 0]
% * Maxima : 1210.6
% * Maximum Dimensionality : 30
%% 
% *Function definition* 
%
% $$f(<x_i>) = \sum_{i=1}^n x_i^2-10 \cos 2\pi x_i+10$$
%
%%
% *3D plot*
    clc; clear
    x = -5:0.1:5; y = -5:0.1:5;
    xy=zeros(length(x)*length(y),2);
    cntpts=0;
    for ii=1:length(x)
        for jj=1:length(y)
            cntpts=cntpts+1;
            xy(cntpts,1:2)=[x(ii),y(jj)];
        end
    end
    funval = Rastrigin([xy]);
    funval = reshape(funval, length(y),length(x));
    surfc(x, y, funval)
%%
% *Other Useful Functions*
% 
% <DeJong>  <Rosenbrock> <Ackley> <Alpine> <Rastrigin>  <Griewank> <Schaffer>
%